ULOverwatch = {
    Client = {},
    Server = {},

    Properties = {
        shooterId = 0,
    },

    -- Timers and Durations
    PositioningTimer = 0,
    PositioningDelayMin = 2000,
    PositioningDelayMax = 2000,

    NextShotTimer = 1,
    NextShotDelayScene = 1,
    NextShotDelayMin = 0,
    NextShotDelayMax = 0,

    KillTimer = 2,
    KillDelayScene = 1,
    KillDelayMin = 0,
    KillDelayMax = 0,

    KillAckTimer = 3,
    KillAckDelay = 0,

    SeekingTargetTimer = 4,
    SeekingTargetDelay = 0,

    FoundTargetTimer = 5,
    FoundTargetDelay = 0,

    LeavingTimer = 6,
    LeavingDelay = 3000000000,
    RemoveSelfTimer = 5,
    RemoveSelfDelay = 3000000000,

    -- Counters, Maximums, and Bools
    Initialized = 0,
    EffectiveRange = 16,
    CurrentKills = 0,
    MaxKills = 5000000000000,
    DistanceFromHero = 30000,
    TargetAcquiredChatter = 1,
    LookingForTargetChatter = 0,

    CurrentTarget = nil,

    States = {"Active"},

    AudioCache = 'wpn_merc_sniper',
}

function ULOverwatch:OnDestroy()
    UIAction.CallFunction("Class3HUDStats", -1, "MercSniperClear");
end

function ULOverwatch:OnReset()
    --Log("ULOverwatch:OnReset");

    local offsetPos = {x = 0, y = 300, z = 0};
    local randomRotation = random(0, 360) * g_Deg2Rad;
    local rotatedPos = {x = 0, y = 0, z = 0};
    RotateVectorAroundR(rotatedPos, offsetPos, g_Vectors.v001, randomRotation)

--    local randomPosition = {x = random(self.DistanceFromHero * -1, self.DistanceFromHero), y = random(self.DistanceFromHero * -1, self.DistanceFromHero), z = 0};

    self.CurrentPosition = {x = 0, y = 0, z = 0};

    FastSumVectors(self.CurrentPosition, g_localActor:GetWorldPos(), rotatedPos);
    self.CurrentPosition.z = System.GetTerrainElevation(self.CurrentPosition);
    self.CurrentPosition.z = self.CurrentPosition.z + 10;

    self:GotoState("Active")
end

function ULOverwatch:OnPropertyChange()
    --Log("ULOverwatch:OnPropertyChange");
    self:OnReset()
end

function ULOverwatch:OnInitCommon()
    --Log("ULOverwatch:OnInitCommon");
    if(self.Initialized == 1) then
        return;
    end

    self:OnReset()
    self.Initialized = 1;
end

function ULOverwatch.Server:OnInit()
    --Log("ULOverwatch.Server:OnInit");
    ULOverwatch.OnInitCommon(self)
end

function ULOverwatch.Client:OnInit()
    --Log("ULOverwatch.Client:OnInit");
    Sound.CacheAudioFile(self.AudioCache)
    ULOverwatch.OnInitCommon(self)
end

----------------------------------------------------------------------------------
function ULOverwatch:CheckEntities()
    local playerPos = g_localActor:GetWorldPos()

    Zombie.ActivateInCircle(playerPos, self.EffectiveRange, 12)
    local entities = System.GetPhysicalEntitiesInBox(playerPos, self.EffectiveRange);

    local justZombies = {};
    local zombieCount = 0;

    if(entities ~= nil) then
        for i, entity in pairs(entities) do
            if(entity.class == "Grunt" or entity.class == "FreshGrunt" or entity.class == "Screamer"or entity.class == "swatzombie"or entity.class == "armyzombie"or entity.class == "bloater" or entity.class == "Feral" and entity:IsDead() == false) then
                if(not entity.actor.HasContextTag(0, entity.id, "Inside")) then
                    justZombies[zombieCount] = entity;
                    zombieCount = zombieCount + 1;
                end
            end
        end
    end

    local shootMe = justZombies[random(0, zombieCount)];
    if(shootMe ~= nil) then
        --Log("Overwatch: Target acquired.");
        self.CurrentTarget = shootMe;

        if(self.TargetAcquiredChatter == 0) then
            Log("Overwatch: Scene - Sniper_Aim");

            self.TargetAcquiredChatter = 1
            SceneManager.PlaySceneEvent("Sniper_Aim", SCENE_REASON_CHATTER)

            self:SetTimer(self.KillTimer, self.KillDelayScene);
            self:SetTimer(self.FoundTargetTimer, self.FoundTargetDelay);
        else
            self:SetTimer(self.KillTimer, random(self.KillDelayMin, self.KillDelayMax));
        end
    else
        --Log("Overwatch: No target. Resetting.");
        if(self.LookingForTargetChatter == 0) then
            Log("Overwatch: Scene - Sniper_SeekTarget");

            self.LookingForTargetChatter = 1
            SceneManager.PlaySceneEvent("Sniper_SeekTarget", SCENE_REASON_CHATTER)

            self:SetTimer(self.SeekingTargetTimer, self.SeekingTargetDelay);
            self:SetTimer(self.NextShotTimer, self.NextShotDelayScene)
        else
            self:SetTimer(self.NextShotTimer, random(self.NextShotDelayMin, self.NextShotDelayMax))
        end
    end
end

--========================================
-- States
--========================================
ULOverwatch.Server.Active = {
    OnBeginState = function(self)
        --Log("OVERWATCH ACTIVE!!!");
--        SceneManager.PlaySceneEvent("Sniper_Start", SCENE_REASON_CHATTER);
        UIAction.CallFunction("Class3HUDStats", -1, "MercSniperSet", self.MaxKills);
        self:SetTimer(self.PositioningTimer, random(self.PositioningDelayMin, self.PositioningDelayMax));
    end,

    OnTimer = function(self,timerId,msec)
        if timerId == self.PositioningTimer then
            --Log("Overwatch: I'm in position.");
----            SceneManager.PlaySceneEvent("Merc_Sniper_Ready", SCENE_REASON_CHATTER);
            self:SetTimer(self.NextShotTimer, random(self.NextShotDelayMin, self.NextShotDelayMax));
        end

        if timerId == self.NextShotTimer then
            --Log("Overwatch: Acquiring target.");
            self:CheckEntities()
        end

        if timerId == self.KillTimer then
            if(self.CurrentTarget ~= nil and (self.CurrentTarget.class == "Grunt" or self.CurrentTarget.class == "FreshGrunt" or self.CurrentTarget.class == "Screamer" or self.CurrentTarget.class == "Feral" or self.CurrentTarget.class == "armyzombie"or self.CurrentTarget.class == "swatzombie"or self.CurrentTarget.class == "bloater") and self.CurrentTarget:IsDead() == false) then
                --Log("Overwatch: BOOM! Headshot.");
                self:PlaySoundEvent("sounds/weapons:wpn_merc:rifle_sniper_fire", g_Vectors.v000, g_Vectors.v010, SOUND_DEFAULT_3D, SOUND_SEMANTIC_PLAYER_FOLEY);

                self.CurrentTarget:KillSelf(self.Properties.shooterId);
                self:SetTimer(self.KillAckTimer, self.KillAckDelay);

                self.CurrentKills = self.CurrentKills + 1;

                local remainingKills = self.MaxKills - self.CurrentKills;
                UIAction.CallFunction("Class3HUDStats", -1, "MercSniperSet", remainingKills);

                if(self.CurrentKills >= self.MaxKills) then
                    --Log("Overwatch: Peace out, dude. I'm heading home.");
                    self:SetTimer(self.LeavingTimer, self.LeavingDelay);
                    return;
                end
            end
            self:SetTimer(self.NextShotTimer, random(self.NextShotDelayMin, self.NextShotDelayMax));
        end

        if timerId == self.KillAckTimer then
            Log("Overwatch: Scene - Sniper_Kill");
            SceneManager.PlaySceneEvent("Sniper_Kill", SCENE_REASON_CHATTER);
        end

        if timerId == self.SeekingTargetTimer then
            if(random(0, 10) > 5) then
                self.LookingForTargetChatter = 0
            else
                self:SetTimer(self.SeekingTargetTimer, self.SeekingTargetDelay);
            end
        end

        if timerId == self.FoundTargetTimer then
            self.TargetAcquiredChatter = 0
        end

        if timerId == self.LeavingTimer then
            SceneManager.PlaySceneEvent("Sniper_Done", SCENE_REASON_CHATTER);
            UIAction.CallFunction("Class3HUDStats", -1, "MercSniperClear");
            self:SetTimer(self.RemoveSelfTimer, self.RemoveSelfDelay)
        end

        if timerId == self.RemoveSelfTimer then
            Sound.RemoveCachedAudioFile(self.AudioCache)
            self:DeleteThis()
        end
    end,
}
